/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.dashloader.thread;

import dev.quantumfusion.dashloader.Dashable;
import dev.quantumfusion.dashloader.registry.RegistryReader;
import dev.quantumfusion.dashloader.registry.RegistryWriter;
import dev.quantumfusion.dashloader.registry.factory.DashFactory;
import dev.quantumfusion.dashloader.thread.ArrayMapTask;
import dev.quantumfusion.dashloader.thread.IndexedArrayMapTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntFunction;

public final class ThreadHandler {
    public static final int CORES = Runtime.getRuntime().availableProcessors();
    private final ForkJoinPool threadPool = new ForkJoinPool(CORES, new ForkJoinPool.ForkJoinWorkerThreadFactory(){
        private final AtomicInteger threadNumber = new AtomicInteger(0);

        @Override
        public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
            ForkJoinWorkerThread dashThread = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
            dashThread.setDaemon(true);
            dashThread.setName("dlc-thread-" + this.threadNumber.getAndIncrement());
            return dashThread;
        }
    }, null, true);

    public static int calcThreshold(int tasks) {
        return Math.max(tasks / (CORES * 32), 4);
    }

    public <R, D extends Dashable<? extends R>> void parallelExport(IndexedArrayMapTask.IndexedArrayEntry<D>[] in, R[] out, RegistryReader reader) {
        this.threadPool.invoke(new IndexedArrayMapTask<Dashable, Object>(in, out, d -> d.export(reader)));
    }

    public <R, D extends Dashable<? extends R>> void parallelExport(D[] in, R[] out, RegistryReader reader) {
        this.threadPool.invoke(new ArrayMapTask<Dashable, Object>(in, out, d -> d.export(reader)));
    }

    public <R, D extends Dashable<? extends R>> void parallelWrite(R[] in, D[] out, RegistryWriter writer, DashFactory<R, ? extends D> factory) {
        this.threadPool.invoke(new ArrayMapTask<Object, Dashable>(in, out, d -> factory.create(d, writer)));
    }

    public void parallelRunnable(Runnable ... runnables) {
        this.parallelRunnable(List.of(runnables));
    }

    public void parallelRunnable(Collection<Runnable> runnables) {
        for (Future future : this.threadPool.invokeAll(runnables.stream().map(Executors::callable).toList())) {
            this.acquire(future);
        }
    }

    @SafeVarargs
    public final <O> O[] parallelCallable(IntFunction<O[]> creator, Callable<O> ... callables) {
        O[] out = creator.apply(callables.length);
        List<Future<O>> futures = this.threadPool.invokeAll(List.of(callables));
        int futuresSize = futures.size();
        for (int i = 0; i < futuresSize; ++i) {
            out[i] = this.acquire(futures.get(i));
        }
        return out;
    }

    public <O> Collection<O> parallelCallable(Collection<Callable<O>> callables) {
        ArrayList<O> out = new ArrayList<O>();
        List<Future<O>> futures = this.threadPool.invokeAll(callables);
        for (Future<O> future : futures) {
            out.add(this.acquire(future));
        }
        return out;
    }

    private <O> O acquire(Future<O> future) {
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

