/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.dashloader.api;

import dev.quantumfusion.dashloader.DashObjectClass;
import dev.quantumfusion.dashloader.Dashable;
import dev.quantumfusion.dashloader.api.hook.LoadCacheHook;
import dev.quantumfusion.dashloader.api.hook.SaveCacheHook;
import java.lang.reflect.InvocationTargetException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModMetadata;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class APIHandler {
    public static final Logger LOGGER = LogManager.getLogger((String)"DashLoaderAPI");
    public static final Class<?>[] HOOK_CLASSES = new Class[]{SaveCacheHook.class, LoadCacheHook.class};
    private final Map<Class<?>, List<Object>> hookSubscribers;
    private final List<DashObjectClass<?, ?>> dashObjects = new ArrayList();
    private boolean initialized = false;
    private boolean failed = false;

    public APIHandler() {
        this.hookSubscribers = new HashMap();
    }

    public <F, D extends Dashable<F>> void registerDashObject(Class<D> dashClass) {
        Class<?>[] interfaces = dashClass.getInterfaces();
        if (interfaces.length == 0) {
            LOGGER.error("No Interfaces found. Class: {}", (Object)dashClass.getSimpleName());
            this.failed = true;
            return;
        }
        this.dashObjects.add(new DashObjectClass(dashClass));
    }

    public <H> void registerHook(Class<H> hookClass) {
        H hook;
        try {
            hook = hookClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            LOGGER.error("Could not find constructor. {}", (Object)hookClass.getSimpleName());
            this.failed = true;
            return;
        }
        catch (InstantiationException | InvocationTargetException e) {
            LOGGER.error("Constructor error.", (Throwable)e);
            this.failed = true;
            return;
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Constructor not accessible. {}", (Object)hookClass.getSimpleName());
            this.failed = true;
            return;
        }
        for (Class<?> aClass : HOOK_CLASSES) {
            if (!aClass.isInstance(hook)) continue;
            this.hookSubscribers.computeIfAbsent(aClass, c -> new ArrayList()).add(hook);
            LOGGER.info("Registered {} as {}", (Object)hookClass.getSimpleName(), (Object)aClass.getSimpleName());
        }
    }

    public <H> void callHook(Class<H> hookClass, Consumer<H> consumer) {
        List<Object> objects = this.hookSubscribers.get(hookClass);
        if (objects != null) {
            objects.forEach(o -> consumer.accept(o));
        }
    }

    public void initAPI() {
        if (!this.initialized) {
            Instant start = Instant.now();
            this.dashObjects.clear();
            FabricLoader.getInstance().getAllMods().forEach(modContainer -> {
                ModMetadata metadata = modContainer.getMetadata();
                if (metadata.getCustomValues().size() != 0) {
                    this.applyForClassesInValue(metadata, "dashloader:dashobject", this::registerDashObject);
                    this.applyForClassesInValue(metadata, "dashloader:hook", this::registerHook);
                }
            });
            if (this.failed) {
                throw new RuntimeException("Failed to initialize the API");
            }
            LOGGER.info("[" + Duration.between(start, Instant.now()).toMillis() + "ms] Initialized api.");
            this.initialized = true;
        }
    }

    private <F, D extends Dashable<F>> void applyForClassesInValue(ModMetadata modMetadata, String valueName, Consumer<Class<D>> func) {
        CustomValue value = modMetadata.getCustomValue(valueName);
        if (value != null) {
            for (CustomValue customValue : value.getAsArray()) {
                String dashObject = customValue.getAsString();
                try {
                    Class<?> closs = Class.forName(dashObject, true, Thread.currentThread().getContextClassLoader());
                    func.accept(closs);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error("Class not found, Mod: \"{}\", Value: \"{}\"", (Object)modMetadata.getId(), (Object)customValue.getAsString());
                    this.failed = true;
                }
                catch (Throwable throwable) {
                    LOGGER.error("Failed to load class. Mod: \"{}\", Value: \"{}\"", (Object)modMetadata.getId(), (Object)customValue.getAsString());
                }
            }
        }
    }

    public List<DashObjectClass<?, ?>> getDashObjects() {
        return this.dashObjects;
    }
}

