/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.dashloader;

import dev.quantumfusion.dashloader.Dashable;
import dev.quantumfusion.dashloader.api.DashDependencies;
import dev.quantumfusion.dashloader.api.DashObject;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DashObjectClass<R, D extends Dashable<R>> {
    private final Class<D> dashClass;
    @Nullable
    private Class<R> targetClass;
    @Nullable
    private Class<? extends Dashable<?>> dashTag;
    @Nullable
    private List<Class<?>> dependencies;

    public DashObjectClass(Class<D> dashClass) {
        this.dashClass = dashClass;
    }

    public Class<D> getDashClass() {
        return this.dashClass;
    }

    @NotNull
    public Class<R> getTargetClass() {
        if (this.targetClass == null) {
            DashObject dashObjectAnnotation = this.dashClass.getDeclaredAnnotation(DashObject.class);
            if (dashObjectAnnotation == null) {
                throw new RuntimeException("Registered Class " + this.dashClass.getSimpleName() + " does not have a @DashObject annotation.");
            }
            this.targetClass = dashObjectAnnotation.value();
        }
        return this.targetClass;
    }

    @NotNull
    public Class<? extends Dashable<?>> getTag() {
        if (this.dashTag == null) {
            Class<Object> dashInterface = null;
            for (Class<?> anInterface : this.dashClass.getInterfaces()) {
                if (!Dashable.class.isAssignableFrom(anInterface)) continue;
                dashInterface = anInterface;
                break;
            }
            if (dashInterface == null) {
                throw new RuntimeException(this.dashClass.getSimpleName() + " does not have an interface that inherits Dashable");
            }
            this.dashTag = dashInterface == Dashable.class ? this.dashClass : dashInterface;
        }
        return this.dashTag;
    }

    @NotNull
    public List<Class<?>> getDependencies() {
        if (this.dependencies == null) {
            DashDependencies dependenciesAnnotation = this.dashClass.getDeclaredAnnotation(DashDependencies.class);
            Class[] dependencies = dependenciesAnnotation == null ? new Class[]{} : dependenciesAnnotation.value();
            for (Class dependency : dependencies) {
                if (dependency.getDeclaredAnnotation(DashObject.class) != null) continue;
                throw new RuntimeException("Registered Class " + this.dashClass.getSimpleName() + " Dependency \"" + dependency.getSimpleName() + "\" does not have a @DashObject annotation and therefore is not a DashObject");
            }
            this.dependencies = List.of(dependencies);
        }
        return this.dependencies;
    }
}

