/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.radar.category;

import com.google.common.collect.Lists;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.PatternSyntaxException;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import xaero.common.minimap.radar.category.EntityRadarCategory;
import xaero.common.minimap.radar.category.serialization.data.EntityRadarCategoryData;
import xaero.common.misc.ListFactory;
import xaero.common.misc.MapFactory;

public final class EntityRadarCategoryConstants {
    public static final ListFactory LIST_FACTORY = ArrayList::new;
    public static final MapFactory MAP_FACTORY = HashMap::new;
    public static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDirectory().toPath().resolve("xaerominimap_entities.json");
    public static final Path DEFAULT_CONFIG_PATH = CONFIG_PATH.getParent().resolveSibling("defaultconfigs").resolve(CONFIG_PATH.toFile().getName());
    public static final Supplier<EntityRadarCategoryData.Builder> DATA_BUILDER_FACTORY = EntityRadarCategoryData.Builder::getDefault;
    public static final Supplier<EntityRadarCategory.Builder> CATEGORY_BUILDER_FACTORY = EntityRadarCategory.Builder::getDefault;
    public static final Function<class_1297, class_1299<?>> DEFAULT_LIST_GETTER = e -> e.method_5864();
    public static final Function<class_1299<?>, String> DEFAULT_LIST_SERIALIZER = t -> class_1299.method_5890((class_1299)t).toString();
    private static final Function<String, String> WILDCARD_TO_REGEX = s -> s.replaceAll("([\\.\\-\\:\\/])", "\\\\$1").replace("*", ".*");
    public static final Function<String, List<class_1299<?>>> DEFAULT_LIST_ELEMENT_RESOLVER = s -> {
        if (class_2960.method_20207((String)s)) {
            class_1299 directReference = class_1299.method_5898((String)s).orElse(null);
            if (directReference == null) {
                return null;
            }
            return Lists.newArrayList((Object[])new class_1299[]{directReference});
        }
        String regexPattern = WILDCARD_TO_REGEX.apply((String)s);
        ArrayList<class_1299> result = new ArrayList<class_1299>();
        try {
            for (class_1299 et : class_2378.field_11145) {
                class_2960 entityTypeLocation = class_1299.method_5890((class_1299)et);
                if (entityTypeLocation == null || !entityTypeLocation.toString().matches(regexPattern)) continue;
                result.add(et);
            }
        }
        catch (PatternSyntaxException pse) {
            return null;
        }
        return result;
    };
    private static final String DEFAULT_LIST_ALLOWED_CHARS = "a-z_0-9\\(\\)\\|:\\/\\-\\.\\*";
    public static final Predicate<String> DEFAULT_LIST_STRING_VALIDATOR = s -> {
        boolean result = s.matches("[a-z_0-9\\(\\)\\|:\\/\\-\\.\\*]*");
        if (result) {
            if (class_2960.method_20207((String)s)) {
                return true;
            }
            try {
                "test string".matches(WILDCARD_TO_REGEX.apply((String)s));
                return true;
            }
            catch (PatternSyntaxException pse) {
                return false;
            }
        }
        return result;
    };
    public static final Function<String, String> DEFAULT_LIST_STRING_VALIDATOR_FIXER = s -> s.replaceAll("[^a-z_0-9\\(\\)\\|:\\/\\-\\.\\*]+", "");
    public static final String CATEGORY_ROOT = "gui.xaero_entity_category_root";
    public static final String CATEGORY_LIVING = "gui.xaero_entity_category_living";
    public static final String CATEGORY_HOSTILE = "gui.xaero_entity_category_hostile";
    public static final String CATEGORY_FRIENDLY = "gui.xaero_entity_category_friendly";
    public static final String CATEGORY_HOSTILE_TAMED = "gui.xaero_entity_category_hostile_tamed";
    public static final String CATEGORY_FRIENDLY_TAMED = "gui.xaero_entity_category_friendly_tamed";
    public static final String CATEGORY_PLAYERS = "gui.xaero_entity_category_players";
    public static final String CATEGORY_SAME_TEAM = "gui.xaero_entity_category_same_team";
    public static final String CATEGORY_OTHER_TEAMS = "gui.xaero_entity_category_other_teams";
    public static final String CATEGORY_ITEMS = "gui.xaero_entity_category_items";
    public static final String CATEGORY_OTHER = "gui.xaero_entity_category_other_entities";
    public static final String HARD_NOTHING = "nothing";
    public static final String HARD_LIVING = "living";
    public static final String HARD_HOSTILE = "hostile";
    public static final String HARD_FRIENDLY = "friendly";
    public static final String HARD_TAMED = "tamed";
    public static final String HARD_PLAYERS = "players";
    public static final String HARD_SAME_TEAM = "same-team";
    public static final String HARD_OTHER_TEAMS = "other-teams";
    public static final String HARD_ITEMS = "items";
    public static final String HARD_ANYTHING = "anything";
    public static final String HARD_BABY = "baby";
    public static final String HARD_VANILLA = "vanilla";
    public static final String HARD_MODDED = "modded";
    public static final String HARD_ABOVE_GROUND = "above-ground";
    public static final String HARD_BELOW_GROUND = "below-ground";
    public static final String HARD_LIT = "block-lit";
    public static final String HARD_UNLIT = "block-unlit";
}

