module.exports = {
    rpcClient: (new (require('discord-rpc')).Client({ transport: 'ipc' })),
    rpcBase: {
        startTimestamp: new Date(),
        largeImageKey: 'e621_large',
        largeImageText: 'On e621',
    },
    oldRPC: {
        details: null,
        state: null,
    },
    async getActivity() {
        (require('child_process')).exec('tasklist /v /fo list /fi "imagename eq e621.exe"| find /i  "window title:"', async (_e, o, _pe) => {
            this.winTitle = o.replace(/(Window Title: )((N\/A)?)(( )+)?/g, '').trim()
            let details, state;
            let fetchedState = await require('./activities.js').getState(this.winTitle);
            state = await fetchedState[0];
            details = await fetchedState[1];
            if (details === false) delete this.rpcBase.details;
            else if (details === true) details = await require('./activities.js').getDetails(this.winTitle);
            details ? this.rpcBase.details = details : delete this.rpcBase.details;
            state ? this.rpcBase.state = state : this.rpcBase.state = 'Idling';
        });
    },
    async startPresence() {
        this.rpcClient.on('ready', async () => {
            console.log('[PRESENCE] Presence manager started!');
            await this.getActivity();
            this.rpcBase.state = 'Just started';
            this.rpcClient.setActivity(this.rpcBase);
            setInterval(async () => {
                this.getActivity();
                if (this.oldRPC?.state !== this.rpcBase?.state && this.oldRPC?.details !== this.rpcBase?.details) {
                    this.rpcClient.setActivity(this.rpcBase);
                    console.log('[PRESENCE] Updating presence');
                    console.log(' > State: ' + (this.rpcBase?.state || null));
                    console.log(' > Details: ' + (this.rpcBase?.details || null));
                    this.oldRPC.details = this.rpcBase?.details;
                    this.oldRPC.state = this.rpcBase?.state;
                }
            }, 1e3);
        }).login({ clientId: '806546934226485299' });
    },
    async stopPresence() {
        this.rpcClient.clearActivity();
        this.rpcClient.destroy();
    }
}