module.exports = {
    activities: {
        "API Key": "Managing settings",
        "Approvals": "Reviewing post approvals",
        "Artist URLs": "Searching for artists'",
        "Artist Versions": "Reviewing artist history",
        "Artists": "Searching for artists",
        "Bans": "Reviewing user bans",
        "Change Password": "Managing settings",
        "Comments": "Reviewing comments",
        "Contact": "Idling",
        "Delete Account": "Managing settings",
        "Feedback": "Reviewing user feedback",
        "Flags": "Reviewing post flags",
        "Forum": "Reading the forum",
        "Keyboard Shortcuts": "Idling",
        "Messages": "Reading messages",
        "MetaSearch - Tags": "Viewing tag listing",
        "Mod Actions": "Reviewing mod actions",
        "New Artist": "Adding new artist",
        "New Message": "Composing a message",
        "New Pool": "Creating a pool",
        "News Updates": "Reading news updates",
        "Pool Gallery": "Searching for pools",
        "Pool Versions": "Reviewing pool history",
        "Pools": "Searching for pools",
        "Popular": "Viewing popular posts",
        "Post Changes": "Reviewing post changes",
        "Post Replacements": "Reviewing post replacements",
        "Related tags": "Viewing tag listing",
        "Rules": "Reading the rules",
        "Search Users": "Searching for users",
        "Settings": "Managing settings",
        "Similar Images Search": "Searching similar images",
        "Site Map": "Reviewing the sitemap",
        "Sign in": "Idling",
        "Tag Aliases": "Viewing tag aliases",
        "Tag Implications": "Viewing tag implications",
        "Tags": "Viewing tag listing",
        "Users": "Searching for users",
        "Wiki": "Reading the wiki",
        "e621": "Idling",
    },
    async getState(winTitle) {
        console.log(`[PRESENCE] Getting state: ${winTitle}`);
        let pog;
        if (Object.keys(this.activities).includes(winTitle.substring(0, winTitle.indexOf(' - e621')))) {
            return [this.activities[winTitle.substring(0, winTitle.indexOf(' - e621'))], false] //pog
        } else {
            if (/#\d+ - e621/g.test(winTitle)) {
                return [`On post ${winTitle?.substring(0, winTitle?.indexOf('- e621') - 1)}`, true];
            } else if (/(\(\d+x\d+\))$/.test(winTitle)) {
               return ['Viewing an image', false];            
            } else if (winTitle.startsWith("Favorites")) {
                return [`${winTitle?.substring(winTitle.indexOf('- ') + 2, winTitle?.indexOf('- e621') - 1)}'s favorites`, true];
            } else if (winTitle.startsWith('User')) {
                return [`On ${winTitle.substring(winTitle.indexOf('- ') + 2, winTitle.indexOf(' - e621'))}'s profile`, true];
            } else if (winTitle.startsWith('Forum') && winTitle !== 'Forum - e621') {
                return [`Reading page ${winTitle.substring(winTitle.indexOf('- '), winTitle.indexOf(' - e621'))}`, true];
            } else if (winTitle.startsWith("Artist")) {
                return [`Artist ${winTitle.substring(winTitle.indexOf('- '), winTitle.indexOf(' - e621'))}`, true];
            } else if (winTitle.startsWith('Wiki') && winTitle !== 'Wiki - e621') {
                return [`Reading page ${winTitle.substring(winTitle.indexOf('- '), winTitle.indexOf(' - e621'))}`, true];
            } else if (winTitle.startsWith('Message')) {
                return [`Reading '${winTitle.substring(winTitle.indexOf('- ') + 2, winTitle.indexOf(' - e621'))}'`, true];
            } else if (winTitle !== 'e621') {
                return [`Searching '${winTitle.substring(0, winTitle.indexOf(' - e621'))}'`, true];
            } else {
                return ['Idling', false];
            };
        }/(\(\d+x\d+\))$/
    },
    async getDetails(winTitle) {
        console.log(`[PRESENCE] Getting detail: ${winTitle}`);
        if (/#\d+ - e621/g.test(winTitle)) {
            return 'Browsing posts';
        } else if (winTitle.startsWith("Favorites")) {
            return 'Browsing favorites';
        } else if (winTitle.startsWith('User')) {
            return 'Viewing a profile';
        } else if (winTitle.startsWith('Forum') && winTitle !== 'Forum - e621') {
            return 'Reading the forum';
        } else if (winTitle.startsWith("Artist")) {
            return 'Viewing artist profile'
        } else if (winTitle.startsWith('Wiki') && winTitle !== 'Wiki - e621') {
            return 'Reading the wiki'
        } else if (winTitle.startsWith('Message')) {
            return 'Reading a message';
        } else if (/[^#].+[ - e621]/g.test(winTitle) && winTitle !== 'e621') {
            return 'Searching for posts';
        } else {
            return null;
        };
    },
};
